/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.FishingHooks;

public class EntityCoFHFishHook
extends EntityFishHook {
    int luckModifier = 0;
    int speedModifier = 0;

    public EntityCoFHFishHook(World world) {
        super(world);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityCoFHFishHook(World world, double d, double d2, double d3, EntityPlayer entityPlayer) {
        super(world, d, d2, d3, entityPlayer);
    }

    public EntityCoFHFishHook(World world, EntityPlayer entityPlayer, int n, int n2) {
        super(world, entityPlayer);
        this.luckModifier = n;
        this.speedModifier = n2;
    }

    public void onUpdate() {
        this.onEntityUpdate();
        if (this.field_146055_aB > 0) {
            double d = this.posX + (this.field_146056_aC - this.posX) / (double)this.field_146055_aB;
            double d2 = this.posY + (this.field_146057_aD - this.posY) / (double)this.field_146055_aB;
            double d3 = this.posZ + (this.field_146058_aE - this.posZ) / (double)this.field_146055_aB;
            double d4 = MathHelper.wrapAngleTo180_double((double)(this.field_146059_aF - (double)this.rotationYaw));
            this.rotationYaw = (float)((double)this.rotationYaw + d4 / (double)this.field_146055_aB);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.field_146060_aG - (double)this.rotationPitch) / (double)this.field_146055_aB);
            --this.field_146055_aB;
            this.setPosition(d, d2, d3);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        } else {
            double d;
            ItemStack itemStack;
            if (!this.worldObj.isRemote) {
                itemStack = this.field_146042_b.getCurrentEquippedItem();
                if (this.field_146042_b.isDead || !this.field_146042_b.isEntityAlive() || itemStack == null || !(itemStack.getItem() instanceof ItemFishingRod) || this.getDistanceSqToEntity((Entity)this.field_146042_b) > 1024.0) {
                    this.setDead();
                    this.field_146042_b.fishEntity = null;
                    return;
                }
                if (this.field_146043_c != null) {
                    if (!this.field_146043_c.isDead) {
                        this.posX = this.field_146043_c.posX;
                        this.posY = this.field_146043_c.boundingBox.minY + (double)this.field_146043_c.height * 0.8;
                        this.posZ = this.field_146043_c.posZ;
                        return;
                    }
                    this.field_146043_c = null;
                }
            }
            if (this.field_146044_a > 0) {
                --this.field_146044_a;
            }
            if (this.field_146051_au) {
                if (this.worldObj.getBlock(this.field_146037_g, this.field_146048_h, this.field_146050_i) == this.field_146046_j) {
                    ++this.field_146049_av;
                    if (this.field_146049_av == 1200) {
                        this.setDead();
                    }
                    return;
                }
                this.field_146051_au = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.field_146049_av = 0;
                this.field_146047_aw = 0;
            } else {
                ++this.field_146047_aw;
            }
            itemStack = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            MovingObjectPosition movingObjectPosition = this.worldObj.rayTraceBlocks((Vec3)itemStack, vec3);
            itemStack = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            if (movingObjectPosition != null) {
                vec3 = Vec3.createVectorHelper((double)movingObjectPosition.hitVec.xCoord, (double)movingObjectPosition.hitVec.yCoord, (double)movingObjectPosition.hitVec.zCoord);
            }
            Entity entity = null;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d5 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                float f;
                AxisAlignedBB axisAlignedBB;
                MovingObjectPosition movingObjectPosition2;
                Entity entity2 = (Entity)list.get(i);
                if (!entity2.canBeCollidedWith() || entity2 == this.field_146042_b && this.field_146047_aw < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.expand((double)(f = 0.3f), (double)f, (double)f)).calculateIntercept((Vec3)itemStack, vec3)) == null || !((d = itemStack.distanceTo(movingObjectPosition2.hitVec)) < d5) && d5 != 0.0) continue;
                entity = entity2;
                d5 = d;
            }
            if (entity != null) {
                movingObjectPosition = new MovingObjectPosition(entity);
            }
            if (movingObjectPosition != null) {
                if (movingObjectPosition.entityHit != null) {
                    if (movingObjectPosition.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.field_146042_b), 0.0f)) {
                        this.field_146043_c = movingObjectPosition.entityHit;
                    }
                } else {
                    this.field_146051_au = true;
                }
            }
            if (!this.field_146051_au) {
                this.moveEntity(this.motionX, this.motionY, this.motionZ);
                float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
                this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
                this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
                while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                    this.prevRotationPitch -= 360.0f;
                }
                while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                    this.prevRotationPitch += 360.0f;
                }
                while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                    this.prevRotationYaw -= 360.0f;
                }
                while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                    this.prevRotationYaw += 360.0f;
                }
                this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
                this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
                float f2 = 0.92f;
                if (this.onGround || this.isCollidedHorizontally) {
                    f2 = 0.5f;
                }
                int n = 5;
                double d6 = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d7 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(i + 0) / (double)n - 0.125 + 0.125;
                    double d8 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(i + 1) / (double)n - 0.125 + 0.125;
                    AxisAlignedBB axisAlignedBB = AxisAlignedBB.getBoundingBox((double)this.boundingBox.minX, (double)d7, (double)this.boundingBox.minZ, (double)this.boundingBox.maxX, (double)d8, (double)this.boundingBox.maxZ);
                    if (!this.worldObj.isAABBInMaterial(axisAlignedBB, Material.water)) continue;
                    d6 += 1.0 / (double)n;
                }
                if (!this.worldObj.isRemote && d6 > 0.0) {
                    WorldServer worldServer = (WorldServer)this.worldObj;
                    int n2 = 1;
                    if (this.rand.nextFloat() < 0.25f && this.worldObj.canLightningStrikeAt(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY) + 1, MathHelper.floor_double((double)this.posZ))) {
                        n2 = 2;
                    }
                    if (this.rand.nextFloat() < 0.5f && !this.worldObj.canBlockSeeTheSky(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY) + 1, MathHelper.floor_double((double)this.posZ))) {
                        --n2;
                    }
                    if (this.field_146045_ax > 0) {
                        --this.field_146045_ax;
                        if (this.field_146045_ax <= 0) {
                            this.field_146040_ay = 0;
                            this.field_146038_az = 0;
                        }
                    } else if (this.field_146038_az > 0) {
                        this.field_146038_az -= n2;
                        if (this.field_146038_az <= 0) {
                            this.motionY -= (double)0.2f;
                            this.playSound("random.splash", 0.25f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                            float f3 = MathHelper.floor_double((double)this.boundingBox.minY);
                            worldServer.func_147487_a("bubble", this.posX, (double)(f3 + 1.0f), this.posZ, (int)(1.0f + this.width * 20.0f), (double)this.width, 0.0, (double)this.width, (double)0.2f);
                            worldServer.func_147487_a("wake", this.posX, (double)(f3 + 1.0f), this.posZ, (int)(1.0f + this.width * 20.0f), (double)this.width, 0.0, (double)this.width, (double)0.2f);
                            this.field_146045_ax = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)10, (int)30);
                        } else {
                            this.field_146054_aA = (float)((double)this.field_146054_aA + this.rand.nextGaussian() * 4.0);
                            float f4 = this.field_146054_aA * ((float)Math.PI / 180);
                            float f5 = MathHelper.sin((float)f4);
                            float f6 = MathHelper.cos((float)f4);
                            double d9 = this.posX + (double)(f5 * (float)this.field_146038_az * 0.1f);
                            double d10 = (float)MathHelper.floor_double((double)this.boundingBox.minY) + 1.0f;
                            double d11 = this.posZ + (double)(f6 * (float)this.field_146038_az * 0.1f);
                            if (this.rand.nextFloat() < 0.15f) {
                                worldServer.func_147487_a("bubble", d9, d10 - (double)0.1f, d11, 1, (double)f5, 0.1, (double)f6, 0.0);
                            }
                            float f7 = f5 * 0.04f;
                            float f8 = f6 * 0.04f;
                            worldServer.func_147487_a("wake", d9, d10, d11, 0, (double)f8, 0.01, (double)(-f7), 1.0);
                            worldServer.func_147487_a("wake", d9, d10, d11, 0, (double)(-f8), 0.01, (double)f7, 1.0);
                        }
                    } else if (this.field_146040_ay != 0) {
                        this.field_146040_ay -= n2;
                        float f9 = 0.15f;
                        if (this.field_146040_ay < 20) {
                            f9 = (float)((double)f9 + (double)(20 - this.field_146040_ay) * 0.05);
                        } else if (this.field_146040_ay < 40) {
                            f9 = (float)((double)f9 + (double)(40 - this.field_146040_ay) * 0.02);
                        } else if (this.field_146040_ay < 60) {
                            f9 = (float)((double)f9 + (double)(60 - this.field_146040_ay) * 0.01);
                        }
                        if (this.rand.nextFloat() < f9) {
                            float f10 = MathHelper.randomFloatClamp((Random)this.rand, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                            float f11 = MathHelper.randomFloatClamp((Random)this.rand, (float)25.0f, (float)60.0f);
                            double d12 = this.posX + (double)(MathHelper.sin((float)f10) * f11 * 0.1f);
                            double d13 = (float)MathHelper.floor_double((double)this.boundingBox.minY) + 1.0f;
                            double d14 = this.posZ + (double)(MathHelper.cos((float)f10) * f11 * 0.1f);
                            worldServer.func_147487_a("splash", d12, d13, d14, 2 + this.rand.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                        }
                        if (this.field_146040_ay <= 0) {
                            this.field_146054_aA = MathHelper.randomFloatClamp((Random)this.rand, (float)0.0f, (float)360.0f);
                            this.field_146038_az = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)20, (int)80);
                        }
                    } else {
                        this.field_146040_ay = MathHelper.getRandomIntegerInRange((Random)this.rand, (int)100, (int)900);
                        this.field_146040_ay -= (EnchantmentHelper.func_151387_h((EntityLivingBase)this.field_146042_b) + this.speedModifier) * 20 * 5;
                    }
                    if (this.field_146045_ax > 0) {
                        this.motionY -= (double)(this.rand.nextFloat() * this.rand.nextFloat() * this.rand.nextFloat()) * 0.2;
                    }
                }
                d = d6 * 2.0 - 1.0;
                this.motionY += (double)0.04f * d;
                if (d6 > 0.0) {
                    f2 = (float)((double)f2 * 0.9);
                    this.motionY *= 0.8;
                }
                this.motionX *= (double)f2;
                this.motionY *= (double)f2;
                this.motionZ *= (double)f2;
                this.setPosition(this.posX, this.posY, this.posZ);
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound nBTTagCompound) {
        super.writeEntityToNBT(nBTTagCompound);
    }

    public void readEntityFromNBT(NBTTagCompound nBTTagCompound) {
        super.readEntityFromNBT(nBTTagCompound);
    }

    public int func_146034_e() {
        if (this.worldObj.isRemote) {
            return 0;
        }
        int n = 0;
        if (this.field_146043_c != null) {
            double d = this.field_146042_b.posX - this.posX;
            double d2 = this.field_146042_b.posY - this.posY;
            double d3 = this.field_146042_b.posZ - this.posZ;
            double d4 = MathHelper.sqrt_double((double)(d * d + d2 * d2 + d3 * d3));
            double d5 = 0.1;
            this.field_146043_c.motionX += d * d5;
            this.field_146043_c.motionY += d2 * d5 + (double)MathHelper.sqrt_double((double)d4) * 0.08;
            this.field_146043_c.motionZ += d3 * d5;
            n = 3;
        } else if (this.field_146045_ax > 0) {
            EntityItem entityItem = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, this.func_146033_f());
            double d = this.field_146042_b.posX - this.posX;
            double d6 = this.field_146042_b.posY - this.posY;
            double d7 = this.field_146042_b.posZ - this.posZ;
            double d8 = MathHelper.sqrt_double((double)(d * d + d6 * d6 + d7 * d7));
            double d9 = 0.1;
            entityItem.motionX = d * d9;
            entityItem.motionY = d6 * d9 + (double)MathHelper.sqrt_double((double)d8) * 0.08;
            entityItem.motionZ = d7 * d9;
            this.worldObj.spawnEntityInWorld((Entity)entityItem);
            this.field_146042_b.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(this.field_146042_b.worldObj, this.field_146042_b.posX, this.field_146042_b.posY + 0.5, this.field_146042_b.posZ + 0.5, this.rand.nextInt(6) + 1));
            n = 1;
        }
        if (this.field_146051_au) {
            n = 2;
        }
        this.setDead();
        this.field_146042_b.fishEntity = null;
        return n;
    }

    protected ItemStack func_146033_f() {
        float f = this.worldObj.rand.nextFloat();
        int n = EnchantmentHelper.func_151386_g((EntityLivingBase)this.field_146042_b) + this.luckModifier;
        int n2 = EnchantmentHelper.func_151387_h((EntityLivingBase)this.field_146042_b) + this.speedModifier;
        this.field_146042_b.addStat(FishingHooks.getFishableCategory((float)f, (int)n, (int)n2).stat, 1);
        return FishingHooks.getRandomFishable((Random)this.rand, (float)f, (int)n, (int)n2);
    }
}

